import polars as pl

def model_week(df: pl.DataFrame, agg_cols) -> pl.DataFrame:
    group = []
    for agg_col in agg_cols:
        group.append(pl.col(agg_col))
    model_week_df = df.select(
        (
            pl.col("datetime").dt.weekday().alias("weekday"),
            pl.col("datetime").dt.hour().alias("hour"),
            pl.col("datetime").dt.minute().alias("minute"),
            pl.all().exclude("datetime"),
        )
    ).group_by(
        group
    ).agg(
        pl.all().mean()
    ).sort(
        group
    ).select(
        pl.datetime(2000, 1, pl.col("weekday"), pl.col("hour"), pl.col("minute")).alias("datetime"),
        pl.all().exclude(["weekday", "hour", "minute"]),
    )
    print(model_week_df)
    return model_week_df

